﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Xml;
using System.Windows.Forms;

namespace PerkEditor
{
    public static partial class Data
    {
        public static void WritePerks()
        {
            StreamWriter writer = new StreamWriter(Config.ServerPath + "/scripts/perks_data.fos");
            writer.WriteLine("// This file has been generated with the Perk Editor. All manual changes will be lost.");
            writer.WriteLine();
            writer.Write("int[][] PerksData = {");
            foreach(Perk p in Perks)
            {
                writer.WriteLine();
                writer.WriteLine("\t{ " + p.Id + ", " + (int)p.Type + ", " + p.MaxLevel + " }, // " + p.Name + ", " + p.Type + ", " + p.MaxLevel + " ranks");
                for(int i = 0; i < p.MaxLevel; i++)
                {
                    writer.WriteLine("\t{ // level " + (i + 1) + " requirements");
                    foreach(Requirement req in p.Levels[i].Requirements)
                        writer.WriteLine("\t\t" + req.Param + ", " + (req.AtLeast ? "1" : "0") + ", " + req.Value + ", // " + req.ToString());
                    writer.WriteLine("\t},");
                }
                writer.WriteLine("#ifdef __SERVER");
                for(int i = 0; i < p.MaxLevel; i++)
                {
                    writer.WriteLine("\t{ // level " + (i + 1) + " perk up effects");
                    foreach(Effect eff in p.Levels[i].UpEffects)
                        writer.WriteLine("\t\t" + eff.Param + ", " + (eff.Increase ? "1" : "0") + ", " + eff.Value + ", // " + eff.ToString());
                    writer.WriteLine("\t},");
                }
                for(int i = 0; i < p.MaxLevel; i++)
                {
                    writer.WriteLine("\t{ // level " + (i + 1) + " perk down effects");
                    if(p.Levels[i].JustRevert)
                    {
                        writer.WriteLine("\t\t-1 // Just revert");
                        writer.WriteLine("\t},");
                        continue;
                    }
                    foreach(Effect eff in p.Levels[i].UpEffects)
                        writer.WriteLine("\t\t" + eff.Param + ", " + (eff.Increase ? "1" : "0") + ", " + eff.Value + ", // " + eff.ToString());
                    writer.WriteLine("\t},");
                }
                writer.WriteLine("#endif");
            }
            writer.WriteLine("\t{ -1, -1, -1}");
            writer.WriteLine("};");
            writer.Close();
        }

        public static void WriteHTML()
        {
            StreamWriter writer = new StreamWriter("perks.html");
            writer.WriteLine("<html><head><title>Perks</title></head><body>Timestamp: " + DateTime.Now.ToString() + "<br><table width=* border=1>");
            foreach(Perk p in Perks)
            {
                if(p.Name.Equals("")) continue;
                writer.WriteLine("<tr><th colspan=3>" + p.Id + ": " + p.Name + " (ranks: " + p.MaxLevel + "), " + p.Type.ToString() + "</th></tr>");
                for(int i = 0; i < p.MaxLevel; i++)
                {
                    writer.Write("<tr><td width=100>Rank " + (i + 1) + "</td><td>");
                    foreach(Requirement req in p.Levels[i].Requirements)
                        writer.Write(req.ToString() + "<br>");
                    writer.Write("</td><td>");
                    foreach(Effect eff in p.Levels[i].UpEffects)
                        writer.Write(eff.ToString() + "<br>");
                }
                writer.WriteLine("</tr><tr><td colspan=3>" + p.Desc + "</td></tr><tr><td></td></tr>");
            }
            writer.WriteLine("</table></body></html>");
            writer.Close();
        }

        public static void WriteWikiPage()
        {
            StreamWriter writer = new StreamWriter("wikipage.txt");
            writer.WriteLine("====== Perks ======");
            writer.WriteLine(@"//Autogenerated by PerkEditor. Manual changes to this page may be lost.//");
            writer.WriteLine(@"//Timestamp: " + DateTime.Now.ToString() + "//");
            writer.WriteLine("\n===== Available on level =====");
            foreach(Perk p in Perks)
            {
                if(p.Name.Equals("")) continue;
                if(p.Type != Perk.PerkType.Levelling) continue;
                writeWikiPerk(writer, p);
            }
            writer.WriteLine("\n===== Support =====");
            foreach(Perk p in Perks)
            {
                if(p.Name.Equals("")) continue;
                if(p.Type != Perk.PerkType.Support) continue;
                writeWikiPerk(writer, p);
            }
            writer.WriteLine("\n===== Disabled =====");
            foreach(Perk p in Perks)
            {
                if(p.Name.Equals("")) continue;
                if(p.Type != Perk.PerkType.Disabled) continue;
                writeWikiPerk(writer, p);
            }
            writer.Close();
        }
        private static void writeWikiPerk(StreamWriter writer, Perk p)
        {
            writer.WriteLine("**" + p.Name + " (" + p.Id + ")**");
            writer.WriteLine("  * Ranks: " + p.MaxLevel);
            writer.Write("  * Generic requirements: ");
            for(int i = 0; i < p.MaxLevel; i++)
            {
                bool first = true;
                foreach(Requirement req in p.Levels[i].Requirements)
                {
                    if(first) first = false;
                    else writer.Write(", ");
                    writer.Write(req.ToString());
                }
                writer.Write(" (rank " + (i + 1) + "); ");
            }
            writer.WriteLine();
            writer.Write("  * Generic effects: ");
            for(int i = 0; i < p.MaxLevel; i++)
            {
                bool first = true;
                foreach(Effect eff in p.Levels[i].UpEffects)
                {
                    if(first) first = false;
                    else writer.Write(", ");
                    writer.Write(eff.ToString());
                }
                writer.Write(" (rank " + (i + 1) + "); ");
            }
            writer.WriteLine();
            writer.WriteLine("  * //" + p.Desc + "//");
        }
    }
}